// Browser shims for Node.js modules used by LangGraph
export class AsyncLocalStorage {
  constructor() {
    this.store = new Map();
  }
  
  run(store, callback, ...args) {
    this.store.set('current', store);
    try {
      return callback(...args);
    } finally {
      this.store.delete('current');
    }
  }
  
  getStore() {
    return this.store.get('current');
  }
}

// Shim for node:crypto
export const crypto = {
  randomUUID: () => {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
      const r = Math.random() * 16 | 0;
      const v = c == 'x' ? r : (r & 0x3 | 0x8);
      return v.toString(16);
    });
  }
};

// Shim for node:fs
export const fs = {};

// Shim for node:path  
export const path = {
  join: (...args) => args.join('/'),
  resolve: (...args) => args.join('/'),
  dirname: (p) => p.split('/').slice(0, -1).join('/'),
  basename: (p) => p.split('/').pop()
};

// Shim for node:url
export const url = {
  fileURLToPath: (url) => url.replace('file://', '')
};