/**
 * Built-in skills that ship with Vibe Browser extension
 * 
 * These skills provide common browser automation patterns that users
 * can use out of the box. They follow the Agent Skills Standard.
 */

export const BUILT_IN_SKILLS: string[] = [
  // Web Search skill
  `---
name: web-search
description: Search the web using Google or other search engines. Use when the user asks to search for information, find websites, or look something up online.
---

When performing a web search:

1. **Navigate to Google** (or the user's preferred search engine)
2. **Enter the search query** in the search box
3. **Submit the search** and wait for results
4. **Analyze the results** - read titles and snippets to find relevant links
5. **Click on the most relevant result** or summarize findings if asked

Tips:
- Use specific, targeted search queries
- If the first result isn't helpful, try refining the search or check other results
- For research tasks, consider visiting multiple sources
- Report back what you found with source URLs
`,

  // Form Fill skill
  `---
name: form-fill
description: Fill out web forms with user-provided information. Use when the user needs to complete forms, sign up for services, or enter data into web pages.
---

When filling out forms:

1. **Identify the form fields** - look for labels, placeholders, and field types
2. **Match user data to fields** - determine which information goes where
3. **Fill fields in order** - start from the top, work down
4. **Handle special fields**:
   - Dropdowns: Click to open, then select the option
   - Checkboxes/radios: Click to toggle
   - Date fields: Enter in the expected format
   - File uploads: Note if files need to be attached
5. **Validate before submitting** - ensure all required fields are filled
6. **Submit the form** if requested

Important:
- Never submit forms with sensitive data (passwords, SSN, credit cards) without explicit user confirmation
- Ask the user if any required information is missing
- Report any validation errors that appear
`,

  // Login skill
  `---
name: login
description: Help users log into websites and services. Use when the user needs to sign in, authenticate, or access their account on a website.
---

When helping with login:

1. **Find the login form** - look for sign in buttons, login links, or existing forms
2. **Identify credential fields** - typically email/username and password
3. **Wait for user to provide credentials** - NEVER guess or store passwords
4. **Enter credentials carefully** - use the fill_by_index tool
5. **Handle 2FA if present** - inform user and wait for verification code
6. **Verify successful login** - check for welcome message, dashboard, or profile

Security rules:
- ALWAYS ask the user for their credentials - never assume or remember them
- If the user says "use my credentials", ask them to provide them now
- Never log credentials in your responses
- Warn about suspicious login pages (check URL carefully)
- If login fails, report the error and ask user to verify credentials
`,

  // LinkedIn Message skill
  `---
name: linkedin-message
description: Compose and send LinkedIn messages, connection requests, or InMails. Use when the user wants to reach out to someone on LinkedIn, reply to messages, or manage LinkedIn communications.
---

When composing LinkedIn messages:

1. **Navigate to the conversation** or profile
   - For existing conversations: Go to LinkedIn Messaging
   - For new outreach: Navigate to the person's profile

2. **Find the message input**
   - Look for contenteditable div with role="textbox"
   - The message box may be in a modal or inline

3. **Compose the message**:
   - Keep it concise and professional
   - Personalize based on context (their role, company, shared connections)
   - If the user provides a template, customize it appropriately
   - Avoid generic or spammy language

4. **Review before sending**:
   - Check for typos
   - Ensure the tone matches the relationship
   - Verify you're messaging the right person

5. **Send or save as draft** based on user preference

Connection requests:
- Include a personalized note (optional but recommended)
- Mention mutual connections or shared interests
- Keep notes under 300 characters

Tips:
- Wait for the message box to be fully loaded before typing
- LinkedIn uses contenteditable divs, use fill_by_index carefully
- Check if the user wants to review the message before sending
`,

  // Gmail Message skill
  `---
name: gmail-message
description: Compose, reply to, and manage Gmail messages. Use when the user wants to send emails, reply to threads, or manage their Gmail inbox.
---

When composing Gmail messages:

1. **Start a new message or reply**:
   - New email: Click "Compose" button
   - Reply: Click reply button in the email thread
   - Reply all: Use "Reply all" for group conversations

2. **Fill in the email fields**:
   - To: Enter recipient email addresses
   - Cc/Bcc: Add if requested (click Cc/Bcc to show fields)
   - Subject: Clear and descriptive
   - Body: The main message content

3. **Compose the message**:
   - Match the formality to the context
   - Use appropriate greeting and sign-off
   - If replying, reference the previous message if relevant
   - Keep it clear and actionable

4. **Attachments**:
   - If user mentions files, note that they need to attach manually
   - Or use the attachment button if instructed

5. **Review and send**:
   - Check recipients carefully
   - Verify subject line
   - Review message for errors
   - Click Send or schedule if requested

Reply etiquette:
- Quote relevant parts of the original message if helpful
- Keep the reply focused on the topic
- Use "Reply all" judiciously

Tips:
- Gmail compose uses contenteditable divs
- Wait for the compose window to fully load
- Check if the user wants to review before sending
- For sensitive emails, always confirm before sending
`,

  // Navigation skill
  `---
name: navigate
description: Navigate websites efficiently. Use for browsing, going back/forward, opening new tabs, or finding specific pages within a site.
---

Navigation strategies:

1. **Direct URL navigation**: Use navigate_to_url for known URLs
2. **Link clicking**: Find and click links using click_by_index
3. **Menu navigation**: Hover over menus, wait for dropdowns, then click
4. **Site search**: Use the site's search feature if available
5. **Breadcrumbs**: Use breadcrumb navigation for hierarchical sites

Multi-tab handling:
- Open new tabs for comparison tasks
- Use switch_tab to move between open tabs
- Close tabs when no longer needed

Back/forward:
- Use go_back to return to previous pages
- Use go_forward after going back
- Prefer clicking links over back button for reliability

Wait for pages:
- After navigation, wait for the page to fully load
- Check for loading indicators before proceeding
- Verify you're on the expected page
`
];

/**
 * Get the default web-search skill content
 */
export function getWebSearchSkill(): string {
  return BUILT_IN_SKILLS[0];
}

/**
 * Get all built-in skill names
 */
export function getBuiltInSkillNames(): string[] {
  return ['web-search', 'form-fill', 'login', 'linkedin-message', 'gmail-message', 'navigate'];
}
