// lib/sentry-ui-init.js
// Sentry initialization for extension UI pages (chat, home, sidepanel, settings)
import { initSentry, captureException } from "./sentry-config.js";

// Initialize Sentry for UI context
const initialized = initSentry({ context: 'ui' });

if (initialized) {
  // Set up global error handlers for UI pages
  window.addEventListener('error', (event) => {
    console.error('[UI] Uncaught error:', event.error);
    captureException(event.error || new Error(event.message), {
      context: 'ui',
      type: 'uncaught_error',
      page: window.location.pathname,
    });
  });

  window.addEventListener('unhandledrejection', (event) => {
    console.error('[UI] Unhandled promise rejection:', event.reason);
    const error = event.reason instanceof Error ? event.reason : new Error(String(event.reason));
    captureException(error, {
      context: 'ui',
      type: 'unhandled_rejection',
      page: window.location.pathname,
    });
  });

  console.log('[Sentry] UI error tracking initialized');
}

export { captureException };
