// Playwright Tools - Browser automation tools using Playwright
export { PlaywrightNavigateTool } from './NavigateTool.js';
export { PlaywrightClickTool } from './ClickTool.js';
export { PlaywrightFillTool } from './FillTool.js';
export { PlaywrightTypeTool } from './TypeTool.js';
export { PlaywrightScreenshotTool } from './ScreenshotTool.js';
export { PlaywrightWaitTool } from './WaitTool.js';
export { PlaywrightScrollTool } from './ScrollTool.js';
export { PlaywrightKeyboardTool } from './KeyboardTool.js';
export { PlaywrightExecuteScriptTool } from './ExecuteScriptTool.js';

// Tab management tools
export {
  PlaywrightListTabsTool,
  PlaywrightCreateNewTabTool
} from './TabManagementTools.js';

// Advanced tools
export {
  PlaywrightHoverTool,
  PlaywrightFindElementTool,
  PlaywrightHighlightElementsTool,
  PlaywrightGetDomStructureTool,
  PlaywrightVerifyActionTool
} from './AdvancedTools.js';

// Secrets management
export { PlaywrightSecretsManager } from './SecretsManager.js';

// New browser-use inspired tools
export { 
  PlaywrightSearchGoogleTool, 
  PlaywrightSearchDuckDuckGoTool 
} from './SearchTool.js';

export { 
  PlaywrightSmartWaitTool,
  PlaywrightExactWaitTool,
  PlaywrightWaitForLoadStateTool
} from './SmartWaitTool.js';

export {
  PlaywrightGoBackTool,
  PlaywrightGoForwardTool,
  PlaywrightReloadTool
} from './GoBackTool.js';

export {
  PlaywrightScrollToTextTool,
  PlaywrightScrollToElementTool
} from './ScrollToTextTool.js';

export {
  PlaywrightAdvancedScrollTool,
  PlaywrightScrollToExtremeTool
} from './AdvancedScrollTool.js';

export {
  PlaywrightEnhancedSendKeysTool,
  PlaywrightTypeTextTool,
  PlaywrightKeyboardComboTool
} from './EnhancedKeyboardTool.js';

export {
  PlaywrightUploadFileTool,
  PlaywrightCreateTestFileTool,
  PlaywrightHandleDownloadTool
} from './UploadFileTool.js';

export {
  PlaywrightGetDropdownOptionsTool,
  PlaywrightSelectDropdownOptionTool
} from './DropdownTool.js';

export {
  PlaywrightWriteFileTool,
  PlaywrightReadFileTool,
  PlaywrightReplaceInFileTool,
  PlaywrightListFilesTool
} from './FileSystemTools.js';

// Search tools - including free and premium options
export {
  PlaywrightTavilySearchTool,
  TavilySearchTool,
  isTavilyConfigured,
  setupTavily
} from './TavilySearchTool.js';

export {
  PlaywrightUniversalSearchTool
} from './UniversalSearchTool.js';

export {
  PlaywrightClickByIndexTool,
  PlaywrightFillByIndexTool
} from './IndexedInteractionTools.js';

// Autocomplete handling
export {
  PlaywrightAutocompleteTool
} from './AutocompleteTool.js';
