import { BrowserTool } from "../../../ai_tools_interface.js";
import { z } from "zod";

export class PlaywrightWaitTool extends BrowserTool {
  constructor(page) {
    super(
      "wait_for_element",
      "Wait for an element to appear on the page",
      z.object({
        selector: z.string().describe("CSS selector to wait for"),
        timeout: z.number().optional().describe("Timeout in milliseconds (default: 30000)"),
        reasoning: z.string().describe("Reasoning for this action")
      })
    );
    this.page = page;
  }

  async call({ selector, timeout = 30000, reasoning }) {
    try {
      await this.page.waitForSelector(selector, { timeout });
      return `Element ${selector} appeared on page`;
    } catch (error) {
      throw new Error(`Wait failed: ${error.message}`);
    }
  }
}