import { BrowserTool } from "../../../ai_tools_interface.js";
import { z } from "zod";

export class PlaywrightTypeTool extends BrowserTool {
  constructor(page) {
    super(
      "type",
      "Type text into the currently focused element",
      z.object({
        text: z.string().describe("Text to type"),
        reasoning: z.string().describe("Reasoning for this action")
      })
    );
    this.page = page;
  }

  async call({ text, reasoning }) {
    try {
      await this.page.keyboard.type(text);
      
      // Wait for any dynamic content changes triggered by typing
      try {
        await this.page.waitForLoadState('networkidle', { timeout: 2000 });
      } catch (timeoutError) {
        // If networkidle times out, wait a bit for any immediate changes
        await this.page.waitForTimeout(500);
      }
      
      return `Typed: "${text}"`;
    } catch (error) {
      throw new Error(`Type failed: ${error.message}`);
    }
  }
}