import { BrowserTool } from "../../../ai_tools_interface.js";
import { z } from "zod";

export class PlaywrightScreenshotTool extends BrowserTool {
  constructor(page) {
    super(
      "take_screenshot",
      "Take a screenshot of the current page",
      z.object({
        path: z.string().optional().describe("Path to save screenshot (optional)"),
        reasoning: z.string().describe("Reasoning for this action")
      })
    );
    this.page = page;
  }

  async call({ path, reasoning }) {
    try {
      const screenshotPath = path || `screenshot-${Date.now()}.png`;
      await this.page.screenshot({ path: screenshotPath, fullPage: false });
      return `Screenshot saved to: ${screenshotPath}`;
    } catch (error) {
      throw new Error(`Screenshot failed: ${error.message}`);
    }
  }
}