import { BrowserTool } from "../../../ai_tools_interface.js";
import { z } from "zod";

export class PlaywrightKeyboardTool extends BrowserTool {
  constructor(page) {
    super(
      "keyboard_shortcut",
      "Send keyboard shortcuts (e.g., Enter, Escape, Ctrl+C)",
      z.object({
        keys: z.string().describe("Key combination (e.g., 'Enter', 'Escape', 'Control+C')"),
        reasoning: z.string().describe("Reasoning for this action")
      })
    );
    this.page = page;
  }

  async call({ keys, reasoning }) {
    try {
      await this.page.keyboard.press(keys);
      
      // Wait for any navigation or form submission triggered by keyboard shortcut
      try {
        await this.page.waitForLoadState('networkidle', { timeout: 3000 });
      } catch (timeoutError) {
        // If networkidle times out, wait a bit for any immediate changes
        await this.page.waitForTimeout(500);
      }
      
      return `Pressed keys: ${keys}`;
    } catch (error) {
      throw new Error(`Keyboard shortcut failed: ${error.message}`);
    }
  }
}