import { BrowserTool } from "../../../ai_tools_interface.js";
import { z } from "zod";

export class PlaywrightExecuteScriptTool extends BrowserTool {
  constructor(page) {
    super(
      "execute_script",
      "Execute JavaScript code in the page context",
      z.object({
        script: z.string().describe("JavaScript code to execute in the page"),
        reasoning: z.string().describe("Reasoning for executing this script")
      })
    );
    this.page = page;
  }

  async call({ script, reasoning }) {
    try {
      // Wait for page to be ready
      await this.page.waitForLoadState('domcontentloaded');
      
      // Execute the script
      const result = await this.page.evaluate(script);
      
      // Return the result
      return `Script executed successfully. Result: ${JSON.stringify(result, null, 2)}`;
    } catch (error) {
      throw new Error(`Script execution failed: ${error.message}`);
    }
  }
}