/**
 * StructuredLogger - A utility for structured logging in the extension
 */
export default class StructuredLogger {
  constructor(module = 'Unknown') {
    this.module = module;
    this.enabled = typeof localStorage !== 'undefined' && localStorage.getItem('vibe_debug_mode') === 'true';
  }

  log(level, message, data = {}) {
    if (!this.enabled && level !== 'error') return;
    
    const timestamp = new Date().toISOString();
    const logEntry = {
      timestamp,
      module: this.module,
      level,
      message,
      ...data
    };

    switch (level) {
      case 'error':
        console.error(`[${this.module}]`, message, data);
        break;
      case 'warn':
        console.warn(`[${this.module}]`, message, data);
        break;
      case 'info':
        console.info(`[${this.module}]`, message, data);
        break;
      case 'debug':
        console.debug(`[${this.module}]`, message, data);
        break;
      default:
        console.log(`[${this.module}]`, message, data);
    }
  }

  error(message, data) {
    this.log('error', message, data);
  }

  warn(message, data) {
    this.log('warn', message, data);
  }

  info(message, data) {
    this.log('info', message, data);
  }

  debug(message, data) {
    this.log('debug', message, data);
  }
}