// OpencodeWebfetchTool.js
// Dynamically loads and registers the opencode webfetch tool for Vibe

import { loadOpencodeTool } from '../../agent/opencodeToolLoader.js';

let opencodeWebfetchToolInstance = null;

/**
 * Returns a singleton instance of the opencode webfetch tool, adapted for Vibe.
 * Usage: await getOpencodeWebfetchTool()
 */
export async function getOpencodeWebfetchTool() {
  if (opencodeWebfetchToolInstance) return opencodeWebfetchToolInstance;
  // Try to load the tool from the opencode plugin package
  opencodeWebfetchToolInstance = await loadOpencodeTool('@opencode-ai/plugin/dist/webfetch.js');
  return opencodeWebfetchToolInstance;
}
