// Browser automation tools - modular organization

// Navigation tools
export { NavigateToURLTool, NavigateTool } from './NavigationTools.js';

// Sub-agent tool for isolated context execution
export { SubAgentTool } from './SubAgentTool.js';

// Parallel execution meta-tool (OpenCode pattern)
export { ParallelTool } from './ParallelTool.js';

// Web fetch tool for non-interactive data extraction
export { WebFetchTool } from './WebFetchTool.js';

// Tab management tools
export { ListTabsTool, CreateNewTabTool, SwitchToTabTool, SetWorkingTabTool } from './TabManagementTools.js';

// Interaction tools
export { ClickTool, TypeTool, FillTool, FindElementTool, WaitForElementTool, ScrollTool } from './InteractionTools.js';

// Advanced interaction tools
export {
  HighlightElementsTool,
  KeypressTool,
  KeyboardShortcutTool,  // Legacy alias
  HoverElementTool,
  SearchAndScrollToTextTool,
  DragDropTool,
  VerifyActionTool
} from './AdvancedInteractionTools.js';

// Miscellaneous tools
export { TakeScreenshotTool } from './MiscTools.js';
export { WaitTool } from '../../common/tools/WaitTool.js';

// Indexed interaction tools (browser-use inspired)
export { ClickByIndexTool, FillByIndexTool, SelectByIndexTool, MediaControlByIndexTool } from './IndexedInteractionTools.js';

// Password manager tool
export { default as PasswordManagerTool } from './PasswordManagerTool.js';

// Google Workspace tools (Gmail, Calendar) - Direct Google API integration
import { 
  googleWorkspaceTools,
  getGoogleWorkspaceTools,
  isGoogleWorkspaceConnected,
  getGoogleWorkspaceStatus,
  GmailSearchTool,
  GmailGetMessageTool,
  GmailGetThreadTool,
  GmailCreateDraftTool,
  GmailSendMessageTool,
  CalendarViewTool,
  CalendarCreateTool
} from './GoogleWorkspaceTools.js';

export { 
  googleWorkspaceTools,
  getGoogleWorkspaceTools,
  isGoogleWorkspaceConnected,
  getGoogleWorkspaceStatus,
  GmailSearchTool,
  GmailGetMessageTool,
  GmailGetThreadTool,
  GmailCreateDraftTool,
  GmailSendMessageTool,
  CalendarViewTool,
  CalendarCreateTool
};

// Export all tools as an array for convenience
import { NavigateToURLTool, NavigateTool } from './NavigationTools.js';
import { ListTabsTool, CreateNewTabTool, SwitchToTabTool, SetWorkingTabTool } from './TabManagementTools.js';
import { ClickTool, TypeTool, FillTool, FindElementTool, ScrollTool } from './InteractionTools.js';
import { ClickByIndexTool, FillByIndexTool, SelectByIndexTool, MediaControlByIndexTool } from './IndexedInteractionTools.js';
import { HighlightElementsTool, KeypressTool, HoverElementTool, SearchAndScrollToTextTool, DragDropTool, VerifyActionTool } from './AdvancedInteractionTools.js';
import { TakeScreenshotTool } from './MiscTools.js';
import { WaitTool } from '../../common/tools/WaitTool.js';
import PasswordManagerTool from './PasswordManagerTool.js';
import { SubAgentTool } from './SubAgentTool.js';
import { ParallelTool } from './ParallelTool.js';
import { WebFetchTool } from './WebFetchTool.js';

export const browserTools = [
  // CORE TOOLS - Optimized set for browser automation
  // Reduced from 20 to 8 essential tools to improve response time

  // Navigation (2 tools)
  new NavigateToURLTool(),
  new NavigateTool(),  // back/forward/refresh

  // Tab management (3 tools) - REQUIRED for multi-tab workflows
  // new ListTabsTool(),      // DISABLED: Tab list already in page state message (pageState.js)
  new CreateNewTabTool(),     // Need to open new tabs for comparisons
  new SwitchToTabTool(),      // Need to switch between tabs (changes focus)
  new SetWorkingTabTool(),    // Set working tab without changing focus (for subagents)

  // Core interaction (5 tools) - Using indexed approach only
  new ClickByIndexTool(),
  new FillByIndexTool(),
  new SelectByIndexTool(),
  new ScrollTool(),
  new MediaControlByIndexTool(),  // Control video/audio elements

  // Timing (1 tool)
  new WaitTool(),

  // Sub-agent for isolated context execution (1 tool)
  new SubAgentTool(),

  // Parallel execution meta-tool (OpenCode pattern) - wraps multiple tool calls
  new ParallelTool(),

  // Web fetch for non-interactive data extraction (faster than subagent for static pages)
  new WebFetchTool(),

  // Advanced interactions - keyboard and hover
  new KeypressTool(),
  new HoverElementTool(),

  // Google Workspace tools (Gmail, Calendar) - always included
  // Tools will return helpful error message if not connected
  ...googleWorkspaceTools,

  // ============ DISABLED TO REDUCE COMPLEXITY ============
  // These tools are disabled to reduce prompt size
  // Re-enable specific tools only when needed for specific tasks

  // new SearchAndScrollToTextTool(),
  // new DragDropTool(),
  // new VerifyActionTool(),

  // Password manager - Only enable for login-specific tasks
  // new PasswordManagerTool(),
];