declare namespace chrome {
  export namespace tabs {
    interface Tab {
      id?: number;
      index: number;
      windowId: number;
      openerTabId?: number;
      highlighted: boolean;
      active: boolean;
      pinned: boolean;
      audible?: boolean;
      discarded: boolean;
      autoDiscardable: boolean;
      groupId: number;
      url?: string;
      pendingUrl?: string;
      title?: string;
      favIconUrl?: string;
      status?: string;
      incognito: boolean;
      width?: number;
      height?: number;
      sessionId?: string;
    }
    function update(tabId: number, updateProperties: object): Promise<void>;
    function create(createProperties: object): Promise<Tab>;
    function get(tabId: number): Promise<Tab>;
    function query(queryInfo: object): Promise<Tab[]>;
    function remove(tabIds: number | number[]): Promise<void>;
    function reload(tabId: number): Promise<void>;
    function captureVisibleTab(windowId?: number, options?: object): Promise<string>;
    function sendMessage(tabId: number, message: object, options?: object): Promise<any>;
  }

  export namespace scripting {
    function executeScript(injection: object): Promise<any[]>;
  }

  export namespace runtime {
    function sendMessage(message: object, options?: object): Promise<any>;
    var onMessage: {
      addListener(callback: (message: any, sender: MessageSender, sendResponse: (response?: any) => void) => boolean | undefined): void;
    };
    var lastError: {
      message: string;
    } | undefined;

    interface MessageSender {
      tab?: tabs.Tab;
      frameId?: number;
      id?: string;
      url?: string;
      tlsChannelId?: string;
      nativeApplication?: string;
      origin?: string;
      unlockedFeatures?: string[];
    }
  }

  export namespace webNavigation {
    var onBeforeNavigate: {
      addListener(callback: (details: WebNavigationDetails) => void): void;
    };

    interface WebNavigationDetails {
      frameId: number;
      parentFrameId: number;
      processId: number;
      tabId: number;
      timeStamp: number;
      url: string;
    }
  }

  export namespace sidePanel {
    function open(options: object): Promise<void>;
    function setPanelBehavior(behavior: object): Promise<void>;
  }

  export namespace storage {
    export namespace local {
      function get(keys?: string | string[] | object): Promise<any>;
      function set(items: object): Promise<void>;
      function remove(keys: string | string[]): Promise<void>;
      function clear(): Promise<void>;
    }
  }


  // Chrome extension API for settings pages
  function send(method: string, args: any[]): void;
}
