/**
 * Event Store for AI Agent
 * Maintains a single source of truth for all agent events
 * Each operation has its own event array that contains the complete history
 */

// Event types that can occur during agent execution
export const EVENT_TYPES = {
  AGENT_STARTED: 'agent_started',
  AI_UPDATE: 'AI_UPDATE',
  PAGE_CONTENT_CAPTURED: 'page_content',
  TOKEN_USAGE: 'token_usage',
  TOOL_ERROR: 'tool_error',
  // Task decomposition events (Claude Code-style)
  PLAN_UPDATE: 'plan_update'
};